<?php defined( 'ABSPATH' ) || die; ?>

<header class="mb-dashboard__header" data-utm="header">
	<a class="mb-dashboard__logo" href="https://metabox.io" target="_blank">
		<svg viewBox="0 0 196 46" fill="none" xmlns="http://www.w3.org/2000/svg">
			<rect width="46" height="46" rx="3" fill="#000"/>
			<path d="M8.68848 35V32.4365L10.959 31.9971V16.6895L8.68848 16.25V13.6719H10.959H17.2871L23.1025 28.54H23.1904L28.8154 13.6719H37.4287V16.25L35.1436 16.6895V31.9971L37.4287 32.4365V35H28.5957V32.4365L30.9834 31.9971V27.9102L31.0566 18.2861L30.9688 18.2715L24.5967 34.707H21.3594L14.8408 18.4033L14.7529 18.418L15.002 27.4707V31.9971L17.5215 32.4365V35H8.68848Z" fill="#fff"/>
			<path d="M55.8203 35V32.4365L58.0908 31.9971V16.6895L55.8203 16.25V13.6719H58.0908H64.4189L70.2344 28.54H70.3223L75.9473 13.6719H84.5605V16.25L82.2754 16.6895V31.9971L84.5605 32.4365V35H75.7275V32.4365L78.1152 31.9971V27.9102L78.1885 18.2861L78.1006 18.2715L71.7285 34.707H68.4912L61.9727 18.4033L61.8848 18.418L62.1338 27.4707V31.9971L64.6533 32.4365V35H55.8203ZM93.1744 35.3076C91.6607 35.3076 90.3375 34.9756 89.2047 34.3115C88.0719 33.6377 87.193 32.7148 86.568 31.543C85.9527 30.3711 85.6451 29.0332 85.6451 27.5293V26.9434C85.6451 25.3711 85.9381 23.9795 86.524 22.7686C87.11 21.5479 87.9352 20.5908 88.9996 19.8975C90.0738 19.2041 91.3385 18.8574 92.7936 18.8574C94.2291 18.8574 95.4352 19.1406 96.4117 19.707C97.3883 20.2734 98.1305 21.0889 98.6383 22.1533C99.1461 23.2178 99.4 24.5068 99.4 26.0205V28.3496H90.0836L90.0543 28.4375C90.1129 29.1309 90.2838 29.751 90.567 30.2979C90.86 30.835 91.2701 31.2598 91.7975 31.5723C92.3248 31.875 92.9645 32.0264 93.7164 32.0264C94.4977 32.0264 95.2252 31.9287 95.899 31.7334C96.5826 31.5283 97.2467 31.2305 97.8912 30.8398L99.0484 33.4766C98.3941 34.0039 97.5689 34.4434 96.5729 34.7949C95.5865 35.1367 94.4537 35.3076 93.1744 35.3076ZM90.1129 25.5225H95.401V25.1416C95.401 24.4971 95.3131 23.9453 95.1373 23.4863C94.9713 23.0176 94.6979 22.6562 94.317 22.4023C93.9459 22.1484 93.4625 22.0215 92.8668 22.0215C92.3004 22.0215 91.8219 22.1729 91.4312 22.4756C91.0406 22.7686 90.733 23.1738 90.5084 23.6914C90.2936 24.209 90.1471 24.7949 90.0689 25.4492L90.1129 25.5225ZM107.003 35.3076C105.529 35.3076 104.391 34.9023 103.59 34.0918C102.799 33.2812 102.404 31.9971 102.404 30.2393V22.1533H100.221V19.1504H102.404V15.2686H106.666V19.1504H109.581V22.1533H106.666V30.2246C106.666 30.8398 106.793 31.2793 107.047 31.543C107.311 31.8066 107.667 31.9385 108.116 31.9385C108.361 31.9385 108.614 31.9238 108.878 31.8945C109.152 31.8555 109.386 31.8164 109.581 31.7773L109.947 34.8682C109.508 34.9951 109.029 35.0977 108.512 35.1758C108.004 35.2637 107.501 35.3076 107.003 35.3076ZM116.262 35.3076C114.689 35.3076 113.439 34.8877 112.512 34.0479C111.584 33.1982 111.12 32.0459 111.12 30.5908C111.12 29.0967 111.725 27.8857 112.936 26.958C114.147 26.0205 115.92 25.5518 118.254 25.5518H120.348V24.3799C120.348 23.6182 120.124 23.0029 119.675 22.5342C119.235 22.0557 118.571 21.8164 117.682 21.8164C117.223 21.8164 116.813 21.875 116.452 21.9922C116.091 22.0996 115.759 22.2559 115.456 22.4609L115.119 24.5557H112.043L111.984 20.4395C112.814 19.9707 113.713 19.5898 114.679 19.2969C115.646 19.0039 116.725 18.8574 117.917 18.8574C119.987 18.8574 121.623 19.3408 122.824 20.3076C124.025 21.2646 124.626 22.6367 124.626 24.4238V30.957C124.626 31.1719 124.626 31.3867 124.626 31.6016C124.636 31.8066 124.655 32.0068 124.684 32.2021L126.34 32.4365V35H121.037C120.929 34.7266 120.822 34.4336 120.715 34.1211C120.607 33.8086 120.529 33.4961 120.48 33.1836C119.972 33.8281 119.372 34.3457 118.679 34.7363C117.995 35.1172 117.189 35.3076 116.262 35.3076ZM117.404 32.1436C118 32.1436 118.566 32.0117 119.103 31.748C119.64 31.4746 120.055 31.1182 120.348 30.6787V28.1738H118.239C117.302 28.1738 116.589 28.3887 116.1 28.8184C115.622 29.248 115.383 29.7656 115.383 30.3711C115.383 30.9375 115.558 31.377 115.91 31.6895C116.271 31.9922 116.769 32.1436 117.404 32.1436ZM133.914 35V32.4365L136.185 31.9971V16.6895L133.914 16.25V13.6719H136.185H143.392C145.901 13.6719 147.859 14.1602 149.266 15.1367C150.672 16.1133 151.375 17.5732 151.375 19.5166C151.375 20.5029 151.111 21.3867 150.584 22.168C150.066 22.9395 149.31 23.5205 148.313 23.9111C149.163 24.0967 149.871 24.4238 150.438 24.8926C151.014 25.3613 151.443 25.9326 151.727 26.6064C152.01 27.2705 152.151 27.998 152.151 28.7891C152.151 30.8301 151.478 32.3779 150.13 33.4326C148.782 34.4775 146.873 35 144.402 35H133.914ZM140.462 31.7188H144.402C145.535 31.7188 146.399 31.4746 146.995 30.9863C147.591 30.4883 147.889 29.7559 147.889 28.7891C147.889 27.7441 147.635 26.9482 147.127 26.4014C146.619 25.8447 145.818 25.5664 144.725 25.5664H140.462V31.7188ZM140.462 22.6074H143.538C144.681 22.6074 145.56 22.373 146.175 21.9043C146.79 21.4355 147.098 20.752 147.098 19.8535C147.098 18.8672 146.785 18.1396 146.16 17.6709C145.545 17.2021 144.622 16.9678 143.392 16.9678H140.462V22.6074ZM160.663 35.3076C159.1 35.3076 157.757 34.9658 156.634 34.2822C155.511 33.5986 154.652 32.6514 154.056 31.4404C153.461 30.2197 153.163 28.8184 153.163 27.2363V26.9287C153.163 25.3564 153.461 23.9648 154.056 22.7539C154.652 21.5332 155.506 20.5811 156.62 19.8975C157.743 19.2041 159.081 18.8574 160.633 18.8574C162.206 18.8574 163.548 19.2041 164.662 19.8975C165.775 20.5811 166.629 21.5283 167.225 22.7393C167.821 23.9502 168.119 25.3467 168.119 26.9287V27.2363C168.119 28.8184 167.821 30.2197 167.225 31.4404C166.629 32.6514 165.775 33.5986 164.662 34.2822C163.548 34.9658 162.215 35.3076 160.663 35.3076ZM160.663 32.0264C161.405 32.0264 162.01 31.8262 162.479 31.4258C162.948 31.0254 163.295 30.4688 163.519 29.7559C163.744 29.0332 163.856 28.1934 163.856 27.2363V26.9287C163.856 25.9912 163.744 25.166 163.519 24.4531C163.295 23.7305 162.943 23.1689 162.464 22.7686C161.996 22.3584 161.385 22.1533 160.633 22.1533C159.901 22.1533 159.296 22.3584 158.817 22.7686C158.338 23.1689 157.987 23.7305 157.762 24.4531C157.547 25.166 157.44 25.9912 157.44 26.9287V27.2363C157.44 28.1934 157.547 29.0332 157.762 29.7559C157.987 30.4785 158.338 31.04 158.817 31.4404C159.296 31.8311 159.911 32.0264 160.663 32.0264ZM168.573 35V32.4365L170.61 32.1729L175.151 27.0605L170.859 21.9775L168.94 21.7285V19.1504H176.791V21.6113L175.561 21.8018L177.861 24.8193L180.16 21.8018L178.798 21.6113V19.1504H186.371V21.7285L184.599 21.9775L180.541 26.8848L185.068 32.1729L187.016 32.4365V35H178.886V32.5537L180.263 32.3633L177.817 29.3311L175.429 32.3779L176.777 32.5537V35H168.573Z" fill="#000"/>
		</svg>
	</a>

	<div class="mb-dashboard__header__search">
		<div class="mb-dashboard__header__search__inner">
			<input type="text" placeholder="<?php esc_attr_e( 'Need some help? Search here...', 'meta-box' ); ?>" />

			<div
				class="mb-dashboard__header__search-results"
				data-searching="<?php esc_html_e( 'Searching...', 'meta-box' ); ?>"
				data-none="<?php esc_html_e( 'No results found.', 'meta-box' ); ?>"
				data-type="empty"
			>
			</div>
		</div>
	</div>

	<div class="mb-dashboard__header__icons">
		<div class="mb-dashboard__header__social">
			<a href="https://www.facebook.com/groups/metaboxusers" target="_blank">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-label="Facebook">
					<path d="M9.101 23.691v-7.98H6.627v-3.667h2.474v-1.58c0-4.085 1.848-5.978 5.858-5.978.401 0 .955.042 1.468.103a8.68 8.68 0 0 1 1.141.195v3.325a8.623 8.623 0 0 0-.653-.036 26.805 26.805 0 0 0-.733-.009c-.707 0-1.259.096-1.675.309a1.686 1.686 0 0 0-.679.622c-.258.42-.374.995-.374 1.752v1.297h3.919l-.386 2.103-.287 1.564h-3.246v8.245C19.396 23.238 24 18.179 24 12.044c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.628 3.874 10.35 9.101 11.647Z"></path>
				</svg>
			</a>
			<a href="https://www.youtube.com/c/MetaBoxWP" target="_blank">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-label="Youtube">
					<path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"></path>
				</svg>
			</a>
			<a href="https://x.com/wpmetabox" target="_blank">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-label="X">
					<path d="M18.901 1.153h3.68l-8.04 9.19L24 22.846h-7.406l-5.8-7.584-6.638 7.584H.474l8.6-9.83L0 1.154h7.594l5.243 6.932ZM17.61 20.644h2.039L6.486 3.24H4.298Z"></path>
				</svg>
			</a>
			<a href="https://www.linkedin.com/company/meta-box/" target="_blank">
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" aria-label="LinkedIn">
					<circle cx="4.983" cy="5.009" r="2.188"></circle>
					<path d="M9.237 8.855v12.139h3.769v-6.003c0-1.584.298-3.118 2.262-3.118 1.937 0 1.961 1.811 1.961 3.218v5.904H21v-6.657c0-3.27-.704-5.783-4.526-5.783-1.835 0-3.065 1.007-3.568 1.96h-.051v-1.66H9.237zm-6.142 0H6.87v12.139H3.095z"></path>
				</svg>
			</a>
		</div>
		<div class="mb-dashboard__header__links">
			<a href="https://docs.metabox.io" target="_blank" class="mb-dashboard__tooltip" data-tooltip="<?php esc_attr_e( 'Documentation', 'meta-box' ); ?>">
				<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
					<path stroke-linecap="round" stroke-linejoin="round" d="M12 6.042A8.967 8.967 0 0 0 6 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 0 1 6 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 0 1 6-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0 0 18 18a8.967 8.967 0 0 0-6 2.292m0-14.25v14.25" />
				</svg>
			</a>
			<a href="#" class="mb-dashboard__tooltip mb-dashboard__news-icon" data-tooltip="<?php esc_attr_e( 'What\'s new?', 'meta-box' ); ?>" data-position="bottom-right">
				<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
					<path stroke-linecap="round" stroke-linejoin="round" d="M14.857 17.082a23.848 23.848 0 0 0 5.454-1.31A8.967 8.967 0 0 1 18 9.75V9A6 6 0 0 0 6 9v.75a8.967 8.967 0 0 1-2.312 6.022c1.733.64 3.56 1.085 5.455 1.31m5.714 0a24.255 24.255 0 0 1-5.714 0m5.714 0a3 3 0 1 1-5.714 0" />
				</svg>
			</a>
		</div>
	</div>
</header>

<div class="mb-dashboard__body">

	<div class="mb-dashboard__main">

		<?php if ( ! $this->is_aio ) : ?>
			<section class="mb-dashboard__intro" data-utm="intro">
				<div class="mb-dashboard__intro__subtitle">
					<?php
					// Translators: %s - current user display name.
					echo esc_html( sprintf( __( 'Hello %s,', 'meta-box' ), wp_get_current_user()->display_name ) );
					?>
				</div>
				<div class="mb-dashboard__intro__title">
					<?php
					// Translators: %s - Meta Box (plugin name).
					echo esc_html( sprintf( __( 'Welcome to %s,', 'meta-box' ), 'Meta Box' ) );
					?>
				</div>
				<div class="mb-dashboard__intro__text">
					<?php
					// Translators: %s - Meta Box (plugin name).
					echo esc_html( sprintf( __( '%s is a powerful, lightweight WordPress plugin for creating custom post types, fields, relationships, and more. With a user-friendly interface and flexible options, it simplifies dynamic content creation without complex coding. Free and reliable, it\'s perfect for beginners and experts alike.', 'meta-box' ), 'Meta Box' ) );
					?>
				</div>

				<?php if ( ! $this->has_actions ) : ?>
					<a class="mb-dashboard__external mb-dashboard__button" href="https://docs.metabox.io/introduction/" target="_blank">
						<?php esc_html_e( 'Get started', 'meta-box' ); ?>
						<svg><use xlink:href="#external-link"></use></svg>
					</a>
				<?php endif; ?>
			</section>
		<?php endif; ?>

		<?php if ( $this->has_actions ) : ?>
			<section class="mb-dashboard__actions">
				<div class="mb-dashboard__actions__title"><?php esc_html_e( 'Getting Started', 'meta-box' ); ?></div>

				<div class="mb-dashboard__actions__inner">
					<a class="mb-dashboard__action" href="<?php echo esc_attr( admin_url( 'post-new.php?post_type=mb-post-type' ) ); ?>">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
							<path d="M5 4a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1zm-.5 2.5A.5.5 0 0 1 5 6h6a.5.5 0 0 1 0 1H5a.5.5 0 0 1-.5-.5M5 8a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1zm0 2a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1z"/>
							<path d="M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2zm10-1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1"/>
						</svg>
						<span class="mb-dashboard__action__text">
							<span class="mb-dashboard__action__title"><?php esc_html_e( 'Create a post type', 'meta-box' ); ?></span>
							<span class="mb-dashboard__action__description"><?php esc_html_e( 'For a new type of content on your website', 'meta-box' ); ?></span>
						</span>
					</a>
					<a class="mb-dashboard__action" href="<?php echo esc_attr( admin_url( 'post-new.php?post_type=mb-taxonomy' ) ); ?>">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
							<path d="M2.5 3.5a.5.5 0 0 1 0-1h11a.5.5 0 0 1 0 1zm2-2a.5.5 0 0 1 0-1h7a.5.5 0 0 1 0 1zM0 13a1.5 1.5 0 0 0 1.5 1.5h13A1.5 1.5 0 0 0 16 13V6a1.5 1.5 0 0 0-1.5-1.5h-13A1.5 1.5 0 0 0 0 6zm1.5.5A.5.5 0 0 1 1 13V6a.5.5 0 0 1 .5-.5h13a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-.5.5z"/>
						</svg>
						<span class="mb-dashboard__action__text">
							<span class="mb-dashboard__action__title"><?php esc_html_e( 'Create a taxonomy', 'meta-box' ); ?></span>
							<span class="mb-dashboard__action__description"><?php esc_html_e( 'To group or categorize your posts', 'meta-box' ); ?></span>
						</span>
					</a>
					<a class="mb-dashboard__action" href="<?php echo esc_attr( admin_url( 'post-new.php?post_type=meta-box' ) ); ?>">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
							<path d="M0 1.5A1.5 1.5 0 0 1 1.5 0h13A1.5 1.5 0 0 1 16 1.5v2A1.5 1.5 0 0 1 14.5 5h-13A1.5 1.5 0 0 1 0 3.5zM1.5 1a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5z"/>
							<path d="M2 2.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5m10.823.323-.396-.396A.25.25 0 0 1 12.604 2h.792a.25.25 0 0 1 .177.427l-.396.396a.25.25 0 0 1-.354 0M0 8a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm1 3v2a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2zm14-1V8a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v2zM2 8.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0 4a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5"/>
						</svg>
						<span class="mb-dashboard__action__text">
							<span class="mb-dashboard__action__title"><?php esc_html_e( 'Create a field group', 'meta-box' ); ?></span>
							<span class="mb-dashboard__action__description"><?php esc_html_e( 'To add custom fields to your posts', 'meta-box' ); ?></span>
						</span>
					</a>
					<a class="mb-dashboard__action" href="<?php echo esc_attr( admin_url( 'post-new.php?post_type=mb-relationship' ) ); ?>">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
							<path fill-rule="evenodd" d="M1 11.5a.5.5 0 0 0 .5.5h11.793l-3.147 3.146a.5.5 0 0 0 .708.708l4-4a.5.5 0 0 0 0-.708l-4-4a.5.5 0 0 0-.708.708L13.293 11H1.5a.5.5 0 0 0-.5.5m14-7a.5.5 0 0 1-.5.5H2.707l3.147 3.146a.5.5 0 1 1-.708.708l-4-4a.5.5 0 0 1 0-.708l4-4a.5.5 0 1 1 .708.708L2.707 4H14.5a.5.5 0 0 1 .5.5"/>
						</svg>
						<span class="mb-dashboard__action__text">
							<span class="mb-dashboard__action__title"><?php esc_html_e( 'Create a relationship', 'meta-box' ); ?></span>
							<span class="mb-dashboard__action__description"><?php esc_html_e( 'To establish connections between posts', 'meta-box' ); ?></span>
						</span>
					</a>

					<?php if ( $this->is_aio ) : ?>
						<a class="mb-dashboard__action" href="<?php echo esc_attr( admin_url( 'post-new.php?post_type=mb-views' ) ); ?>">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
								<path d="M14 4.5V14a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h5.5zm-3 0A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V4.5z"/>
								<path d="M8.646 6.646a.5.5 0 0 1 .708 0l2 2a.5.5 0 0 1 0 .708l-2 2a.5.5 0 0 1-.708-.708L10.293 9 8.646 7.354a.5.5 0 0 1 0-.708m-1.292 0a.5.5 0 0 0-.708 0l-2 2a.5.5 0 0 0 0 .708l2 2a.5.5 0 0 0 .708-.708L5.707 9l1.647-1.646a.5.5 0 0 0 0-.708"/>
							</svg>
							<span class="mb-dashboard__action__text">
								<span class="mb-dashboard__action__title"><?php esc_html_e( 'Create a view', 'meta-box' ); ?></span>
								<span class="mb-dashboard__action__description"><?php esc_html_e( 'To output fields on the frontend', 'meta-box' ); ?></span>
							</span>
						</a>

						<a class="mb-dashboard__action" href="<?php echo esc_attr( admin_url( 'post-new.php?post_type=mb-settings-page' ) ); ?>">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16">
								<path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492M5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0"/>
								<path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52zm-2.633.283c.246-.835 1.428-.835 1.674 0l.094.319a1.873 1.873 0 0 0 2.693 1.115l.291-.16c.764-.415 1.6.42 1.184 1.185l-.159.292a1.873 1.873 0 0 0 1.116 2.692l.318.094c.835.246.835 1.428 0 1.674l-.319.094a1.873 1.873 0 0 0-1.115 2.693l.16.291c.415.764-.42 1.6-1.185 1.184l-.291-.159a1.873 1.873 0 0 0-2.693 1.116l-.094.318c-.246.835-1.428.835-1.674 0l-.094-.319a1.873 1.873 0 0 0-2.692-1.115l-.292.16c-.764.415-1.6-.42-1.184-1.185l.159-.291A1.873 1.873 0 0 0 1.945 8.93l-.319-.094c-.835-.246-.835-1.428 0-1.674l.319-.094A1.873 1.873 0 0 0 3.06 4.377l-.16-.292c-.415-.764.42-1.6 1.185-1.184l.292.159a1.873 1.873 0 0 0 2.692-1.115z"/>
							</svg>
							<span class="mb-dashboard__action__text">
								<span class="mb-dashboard__action__title"><?php esc_html_e( 'Create a settings page', 'meta-box' ); ?></span>
								<span class="mb-dashboard__action__description"><?php esc_html_e( 'For global settings of your website', 'meta-box' ); ?></span>
							</span>
						</a>
					<?php endif; ?>
				</div>
			</section>
		<?php endif; ?>

		<section class="mb-dashboard__info">
			<div class="mb-dashboard__tabs">
				<div class="mb-dashboard__tab mb-dashboard__tab--active" data-tab="tutorials">
					<?php esc_html_e( 'Tutorials', 'meta-box' ); ?>
				</div>

				<?php if ( $this->upgradable ) : ?>
					<div class="mb-dashboard__tab" data-tab="compare">
						<?php esc_html_e( 'Upgrade', 'meta-box' ); ?>
						<span class="mb-dashboard__tab__badge"><?php esc_html_e( 'Cool', 'meta-box' ); ?></span>
					</div>
				<?php endif; ?>
			</div>
			<div class="mb-dashboard__tab-pane mb-dashboard__tutorials" data-tab="tutorials" data-utm="tutorials">
				<div class="mb-dashboard__tutorials__inner">
					<div class="mb-dashboard__tutorial">
						<a
							class="mb-dashboard__tutorial__image lightbox mb-dashboard__tooltip"
							data-featherlight="iframe"
							data-featherlight-iframe-frameborder="0"
							data-featherlight-iframe-allow="autoplay; encrypted-media"
							data-featherlight-iframe-allowfullscreen="true"
							data-featherlight-iframe-style="display:block;border:none;height:85vh;width:85vw;"
							href="http://www.youtube.com/embed/-oYrHGOri4w"
							data-tooltip="<?php esc_attr_e( 'Click to view the video version', 'meta-box' ); ?>"
							data-position="top"
						>
							<img src="<?php echo esc_attr( "{$this->assets_url}/img/create-post-types.png" ); ?>" alt="<?php esc_attr_e( 'Creating post types and taxonomies', 'meta-box' ); ?>">
						</a>
						<div class="mb-dashboard__tutorial__text">
							<a class="mb-dashboard__tutorial__title" href="https://docs.metabox.io/tutorials/create-custom-post-types-taxonomies/" target="_blank"><?php esc_html_e( 'Creating post types and taxonomies', 'meta-box' ); ?></a>
							<div class="mb-dashboard__tutorial__description">
								<?php esc_html_e( 'Step-by-step guide to create custom post types and custom taxonomies.', 'meta-box' ); ?>
							</div>
						</div>
					</div>

					<div class="mb-dashboard__tutorial">
						<a
							class="mb-dashboard__tutorial__image lightbox mb-dashboard__tooltip"
							data-featherlight="iframe"
							data-featherlight-iframe-frameborder="0"
							data-featherlight-iframe-allow="autoplay; encrypted-media"
							data-featherlight-iframe-allowfullscreen="true"
							data-featherlight-iframe-style="display:block;border:none;height:85vh;width:85vw;"
							href="http://www.youtube.com/embed/VEZSCHtOt5Q"
							data-tooltip="<?php esc_attr_e( 'Click to view the video version', 'meta-box' ); ?>"
							data-position="top"
						>
							<img src="<?php echo esc_attr( "{$this->assets_url}/img/change-id.png" ); ?>" alt="<?php esc_attr_e( 'Changing the ID of a field', 'meta-box' ); ?>">
						</a>
						<div class="mb-dashboard__tutorial__text">
							<a class="mb-dashboard__tutorial__title" href="https://docs.metabox.io/tutorials/change-id-meta-box-field/" target="_blank"><?php esc_html_e( 'Changing the ID of a field', 'meta-box' ); ?></a>
							<div class="mb-dashboard__tutorial__description">
								<?php esc_html_e( 'If you want to change a field ID after entering data, here is the guide.', 'meta-box' ); ?>
							</div>
						</div>
					</div>

					<div class="mb-dashboard__tutorial">
						<a
							class="mb-dashboard__tutorial__image lightbox mb-dashboard__tooltip"
							data-featherlight="iframe"
							data-featherlight-iframe-frameborder="0"
							data-featherlight-iframe-allow="autoplay; encrypted-media"
							data-featherlight-iframe-allowfullscreen="true"
							data-featherlight-iframe-style="display:block;border:none;height:85vh;width:85vw;"
							href="http://www.youtube.com/embed/_DaFUt92kYY"
							data-tooltip="<?php esc_attr_e( 'Click to view the video version', 'meta-box' ); ?>"
							data-position="top"
						>
							<img src="<?php echo esc_attr( "{$this->assets_url}/img/create-custom-fields.png" ); ?>" alt="<?php esc_attr_e( 'Creating and configure custom fields', 'meta-box' ); ?>">
						</a>
						<div class="mb-dashboard__tutorial__text">
							<a class="mb-dashboard__tutorial__title" href="https://docs.metabox.io/tutorials/create-custom-fields/" target="_blank"><?php esc_html_e( 'Creating and configure custom fields', 'meta-box' ); ?></a>
							<div class="mb-dashboard__tutorial__description">
								<?php esc_html_e( 'Understanding custom fields and how to create them with Meta Box.', 'meta-box' ); ?>
							</div>
						</div>
					</div>

					<div class="mb-dashboard__tutorial">
						<a
							class="mb-dashboard__tutorial__image lightbox mb-dashboard__tooltip"
							data-featherlight="iframe"
							data-featherlight-iframe-frameborder="0"
							data-featherlight-iframe-allow="autoplay; encrypted-media"
							data-featherlight-iframe-allowfullscreen="true"
							data-featherlight-iframe-style="display:block;border:none;height:85vh;width:85vw;"
							href="http://www.youtube.com/embed/pFgElK8pvn0"
							data-tooltip="<?php esc_attr_e( 'Click to view the video version', 'meta-box' ); ?>"
							data-position="top"
						>
							<img src="<?php echo esc_attr( "{$this->assets_url}/img/category-thumbnails.png" ); ?>" alt="<?php esc_attr_e( 'Creating category thumbnails', 'meta-box' ); ?>">
						</a>
						<div class="mb-dashboard__tutorial__text">
							<a class="mb-dashboard__tutorial__title" href="https://docs.metabox.io/tutorials/category-thumbnails/" target="_blank"><?php esc_html_e( 'Creating category thumbnails', 'meta-box' ); ?></a>
							<div class="mb-dashboard__tutorial__description">
								<?php esc_html_e( 'How to create featured images for categories and show them on the frontend.', 'meta-box' ); ?>
							</div>
						</div>
					</div>

					<div class="mb-dashboard__tutorial">
						<a
							class="mb-dashboard__tutorial__image lightbox mb-dashboard__tooltip"
							data-featherlight="iframe"
							data-featherlight-iframe-frameborder="0"
							data-featherlight-iframe-allow="autoplay; encrypted-media"
							data-featherlight-iframe-allowfullscreen="true"
							data-featherlight-iframe-style="display:block;border:none;height:85vh;width:85vw;"
							href="http://www.youtube.com/embed/Byce7gfpZJQ"
							data-tooltip="<?php esc_attr_e( 'Click to view the video version', 'meta-box' ); ?>"
							data-position="top"
						>
							<img src="<?php echo esc_attr( "{$this->assets_url}/img/filter-posts.png" ); ?>" alt="<?php esc_attr_e( 'Filtering posts by custom fields and taxonomies', 'meta-box' ); ?>">
						</a>
						<div class="mb-dashboard__tutorial__text">
							<a class="mb-dashboard__tutorial__title" href="https://docs.metabox.io/tutorials/filter-posts-by-custom-fields-taxonomies/" target="_blank"><?php esc_html_e( 'Filtering posts by custom fields and taxonomies', 'meta-box' ); ?></a>
							<div class="mb-dashboard__tutorial__description">
								<?php esc_html_e( 'How to query, filter and show posts by taxonomies and by custom fields.', 'meta-box' ); ?>
							</div>
						</div>
					</div>

					<div class="mb-dashboard__tutorial">
						<a
							class="mb-dashboard__tutorial__image lightbox mb-dashboard__tooltip"
							data-featherlight="iframe"
							data-featherlight-iframe-frameborder="0"
							data-featherlight-iframe-allow="autoplay; encrypted-media"
							data-featherlight-iframe-allowfullscreen="true"
							data-featherlight-iframe-style="display:block;border:none;height:85vh;width:85vw;"
							href="http://www.youtube.com/embed/ev24jQJTgCY"
							data-tooltip="<?php esc_attr_e( 'Click to view the video version', 'meta-box' ); ?>"
							data-position="top"
						>
							<img src="<?php echo esc_attr( "{$this->assets_url}/img/recipe.png" ); ?>" alt="<?php esc_attr_e( 'Creating a recipe with Meta Box and Bricks', 'meta-box' ); ?>">
						</a>
						<div class="mb-dashboard__tutorial__text">
							<a class="mb-dashboard__tutorial__title" href="https://docs.metabox.io/tutorials/create-recipes-meta-box-bricks/" target="_blank"><?php esc_html_e( 'Creating a recipe with Meta Box and Bricks', 'meta-box' ); ?></a>
							<div class="mb-dashboard__tutorial__description">
								<?php esc_html_e( 'How to create a post type with custom fields and show them with Bricks.', 'meta-box' ); ?>
							</div>
						</div>
					</div>

					<div class="mb-dashboard__tutorial">
						<a
							class="mb-dashboard__tutorial__image lightbox mb-dashboard__tooltip"
							data-featherlight="iframe"
							data-featherlight-iframe-frameborder="0"
							data-featherlight-iframe-allow="autoplay; encrypted-media"
							data-featherlight-iframe-allowfullscreen="true"
							data-featherlight-iframe-style="display:block;border:none;height:85vh;width:85vw;"
							href="http://www.youtube.com/embed/BGVY-5W6d7g"
							data-tooltip="<?php esc_attr_e( 'Click to view the video version', 'meta-box' ); ?>"
							data-position="top"
						>
							<img src="<?php echo esc_attr( "{$this->assets_url}/img/export-import-custom-fields.png" ); ?>" alt="<?php esc_attr_e( 'Export and import custom fields', 'meta-box' ); ?>">
						</a>
						<div class="mb-dashboard__tutorial__text">
							<a class="mb-dashboard__tutorial__title" href="https://docs.metabox.io/tutorials/export-import-custom-fields-meta-box-builder/" target="_blank"><?php esc_html_e( 'Export and import custom fields', 'meta-box' ); ?></a>
							<div class="mb-dashboard__tutorial__description">
								<?php esc_html_e( 'How to export custom fields settings and data and import them into another site.', 'meta-box' ); ?>
							</div>
						</div>
					</div>

					<div class="mb-dashboard__tutorial">
						<a
							class="mb-dashboard__tutorial__image lightbox mb-dashboard__tooltip"
							data-featherlight="iframe"
							data-featherlight-iframe-frameborder="0"
							data-featherlight-iframe-allow="autoplay; encrypted-media"
							data-featherlight-iframe-allowfullscreen="true"
							data-featherlight-iframe-style="display:block;border:none;height:85vh;width:85vw;"
							href="http://www.youtube.com/embed/6mHDBIO_qlY"
							data-tooltip="<?php esc_attr_e( 'Click to view the video version', 'meta-box' ); ?>"
							data-position="top"
						>
							<img src="<?php echo esc_attr( "{$this->assets_url}/img/simple-listings.png" ); ?>" alt="<?php esc_attr_e( 'Creating a listing site with Meta Box and Elementor', 'meta-box' ); ?>">
						</a>
						<div class="mb-dashboard__tutorial__text">
							<a class="mb-dashboard__tutorial__title" href="https://docs.metabox.io/tutorials/create-simple-listing-with-elementor/" target="_blank"><?php esc_html_e( 'Creating a listing site with Meta Box and Elementor', 'meta-box' ); ?></a>
							<div class="mb-dashboard__tutorial__description">
								<?php esc_html_e( 'How to create listings and use Elementor to show and filter them.', 'meta-box' ); ?>
							</div>
						</div>
					</div>
				</div>

				<a href="https://docs.metabox.io/tutorials/" target="_blank" class="mb-dashboard__external">
					<?php esc_html_e( 'View all tutorials', 'meta-box' ); ?>
					<svg><use xlink:href="#external-link"></use></svg>
				</a>
			</div>

			<?php if ( $this->upgradable ) : ?>
				<div class="mb-dashboard__tab-pane mb-dashboard__hidden mb-dashboard__compare" data-tab="compare" data-utm="compare">
					<div class="mb-dashboard__compare__header">
						<div>
							<div class="mb-dashboard__compare__title">
								<?php
								// Translators: %s - Meta Box AIO.
								echo esc_html( sprintf( __( 'Get access to %s', 'meta-box' ), 'Meta Box AIO' ) );
								?>
							</div>
							<p><?php esc_html_e( 'An all-in-one plugin that provides all free & pro Meta Box extensions for building powerful and dynamic WordPress websites!', 'meta-box' ); ?></p>
						</div>

						<a class="mb-dashboard__button" href="https://metabox.io/pricing/" target="_blank"><?php esc_html_e( 'Upgrade now', 'meta-box' ); ?></a>
					</div>

					<table>
						<thead>
							<tr>
								<th align="left"><?php esc_html_e( 'Feature', 'meta-box' ); ?></th>
								<th align="center">Meta Box Lite</th>
								<th align="center">Meta Box AIO</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php esc_html_e( 'Pricing', 'meta-box' ); ?></td>
								<td align="center"><?php esc_html_e( 'Free', 'meta-box' ); ?></td>
								<td align="center"><?php esc_html_e( 'Paid', 'meta-box' ); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'The Meta Box framework', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create custom post types & taxonomies', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create custom fields with UI', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Migration from ACF, Pods, Toolset', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Integrations with Elementor, Divi, FacetWP, Yoast SEO,...', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Relationships', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Get/set meta values with REST API', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Limit text length', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Add custom fields to comments in WordPress', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Auto update', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create custom fields for taxonomies', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create custom fields for users', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create custom settings pages', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create Customizer sections & panels', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create user profile', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create custom content models and save their data to custom tables', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Organize custom fields into repeatable groups', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Advanced location rules for field groups', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Toggle fields or field groups with conditional logic', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Frontend submission forms and dashboard', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create templates and displaying fields with views', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Save post/term meta to custom tables', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Create custom Gutenberg blocks', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Display fields in admin columns', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'UI features: columns, tooltips, tabs', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Premium support', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
							<tr>
								<td><?php esc_html_e( 'Licensing management system, including sub-licensing', 'meta-box' ); ?></td>
								<td align="center"><svg><use xlink:href="#x-circle"></use></svg></td>
								<td align="center"><svg><use xlink:href="#check-circle"></use></svg></td>
							</tr>
						</tbody>
						<tfoot>
							<tr>
								<td><?php esc_html_e( 'Learn more', 'meta-box' ); ?></td>
								<td align="center">
									<a class="mb-dashboard__external" href="https://metabox.io/lite/" target="_blank">
										Meta Box Lite
										<svg><use xlink:href="#external-link"></use></svg>
									</a>
								</td>
								<td align="center">
									<a class="mb-dashboard__external" href="https://metabox.io/aio/" target="_blank">
										Meta Box AIO
										<svg><use xlink:href="#external-link"></use></svg>
									</a>
								</td>
							</tr>
						</tfoot>
					</table>

					<div class="mb-dashboard__compare__footer">
						<div class="mb-dashboard__compare__title">
							<?php
							// Translators: %s - Meta Box AIO.
							echo esc_html( sprintf( __( 'Do more with %s', 'meta-box' ), 'Meta Box AIO' ) );
							?>
						</div>
						<p><?php esc_html_e( 'Get access to the all-in-one version of Meta Box with full of top-notch features for building robust and dynamic websites.', 'meta-box' ); ?></p>

						<a class="mb-dashboard__button" href="https://metabox.io/pricing/" target="_blank"><?php esc_html_e( 'Upgrade now', 'meta-box' ); ?></a>
					</div>
				</div>
			<?php endif; ?>
		</section>
	</div>

	<aside class="mb-dashboard__sidebar" data-utm="sidebar">
		<?php
		$utc_timezone = new \DateTimeZone( 'UTC' );
		$now = new \DateTime( 'now', $utc_timezone );
		$sale_end1 = new \DateTime( '2025-11-29 00:00:00', $utc_timezone );
		$sale_end2 = new \DateTime( '2025-12-02 00:00:00', $utc_timezone );
		if ( $now < $sale_end2 ) :
			?>
			<div class="mb-dashboard__widget mb-dashboard__sale" data-utm="sale">
				<div class="mb-dashboard__widget-title">
					<?php esc_html_e( 'Black Friday Sale', 'meta-box' ); ?>
					<span class="mb-dashboard__sale__badge"><?php esc_html_e( 'Hot', 'meta-box' ); ?></span>
				</div>
				<div class="mb-dashboard__widget-body">
					<p><?php esc_html_e( 'Upgrade your package and optimize the workflow at the best price!', 'meta-box' ); ?></p>
					<a class="mb-dashboard__sale__button" href="https://metabox.io/black-friday/" target="_blank">
						<?php if ( $now < $sale_end1 ) : ?>
							<span class="mb-dashboard__sale__button-text--large"><?php esc_html_e( 'Get 40% OFF now', 'meta-box' ); ?></span>
						<?php else : ?>
							<span class="mb-dashboard__sale__button-text--large"><?php esc_html_e( 'Get 25% OFF now', 'meta-box' ); ?></span>
						<?php endif; ?>
						<span class="mb-dashboard__sale__button-text--small"><?php esc_html_e( 'on annual plans', 'meta-box' ); ?></span>
					</a>
					<ul class="mb-dashboard__countdown" data-end="<?= $now < $sale_end1 ? '2025-11-29T00:00:00+00:00' : '2025-12-02T00:00:00+00:00' ?>">
						<li>
							<div class="mb-dashboard__countdown-number" data-type="days">0</div>
							<div class="mb-dashboard__countdown-label">Days</div>
						</li>
						<li>
							<div class="mb-dashboard__countdown-number" data-type="hours">0</div>
							<div class="mb-dashboard__countdown-label">Hours</div>
						</li>
						<li>
							<div class="mb-dashboard__countdown-number" data-type="minutes">0</div>
							<div class="mb-dashboard__countdown-label">Min.</div>
						</li>
						<li>
							<div class="mb-dashboard__countdown-number" data-type="seconds">0</div>
							<div class="mb-dashboard__countdown-label">Sec.</div>
						</li>
					</ul>
					<script>
						document.querySelectorAll( '.mb-dashboard__countdown' ).forEach( el => {
							const days = el.querySelector( '[data-type="days"]' );
							const hours = el.querySelector( '[data-type="hours"]' );
							const minutes = el.querySelector( '[data-type="minutes"]' );
							const seconds = el.querySelector( '[data-type="seconds"]' );

							const countdown = () => {
								const time = new Date( el.dataset.end ).getTime();
								const now = new Date().getTime();
								const distance = ( time - now ) / 1000;

								if ( distance < 0 ) {
									days.innerHTML = '0';
									hours.innerHTML = '0';
									minutes.innerHTML = '0';
									seconds.innerHTML = '0';
									clearInterval( timer );
									return;
								}

								days.innerHTML = Math.floor( distance / 86400 );
								hours.innerHTML = Math.floor( ( distance % 86400 ) / 3600 );
								minutes.innerHTML = Math.floor( ( distance % 3600 ) / 60 );
								seconds.innerHTML = Math.floor( distance % 60 );
							};

							const timer = setInterval( countdown, 1000 );
						} );
					</script>
				</div>
			</div>
		<?php endif; ?>
		<?php if ( $this->upgradable ) : ?>
			<div class="mb-dashboard__widget mb-dashboard__upgrade" data-utm="cta">
				<div class="mb-dashboard__widget-title"><?php esc_html_e( 'Wanna advanced features?', 'meta-box' ); ?></div>
				<div class="mb-dashboard__widget-body">
					<ul>
						<li><svg><use xlink:href="#check-circle-solid"></use></svg><?php esc_html_e( 'Organize fields into groups (repeater)', 'meta-box' ); ?></li>
						<li><svg><use xlink:href="#check-circle-solid"></use></svg><?php esc_html_e( 'More location rules & conditional logic', 'meta-box' ); ?></li>
						<li><svg><use xlink:href="#check-circle-solid"></use></svg><?php esc_html_e( 'Custom tables to boost performance', 'meta-box' ); ?></li>
						<li><svg><use xlink:href="#check-circle-solid"></use></svg><?php esc_html_e( 'Create custom blocks with low code', 'meta-box' ); ?></li>
						<li><svg><use xlink:href="#check-circle-solid"></use></svg><?php esc_html_e( 'Create login, register & edit profile pages', 'meta-box' ); ?></li>
						<li><svg><use xlink:href="#check-circle-solid"></use></svg><?php esc_html_e( 'Submit & manage posts on the frontend', 'meta-box' ); ?></li>
						<li><svg><use xlink:href="#check-circle-solid"></use></svg><?php esc_html_e( 'Priority support', 'meta-box' ); ?></li>
						<li><svg><use xlink:href="#check-circle-solid"></use></svg><?php esc_html_e( 'And much more!', 'meta-box' ); ?></li>
					</ul>
					<a class="mb-dashboard__button" target="_blank" href="https://metabox.io/pricing/"><?php esc_html_e( 'Upgrade Now', 'meta-box' ); ?></a>
				</div>
				<img src="<?php echo esc_attr( "{$this->assets_url}/img/bulb.svg" ); ?>" />
			</div>
		<?php else : ?>
			<div class="mb-dashboard__widget mb-dashboard__support" data-utm="support">
				<div class="mb-dashboard__widget-title"><?php esc_html_e( 'Premium support', 'meta-box' ); ?></div>
				<div class="mb-dashboard__widget-body">
					<p><?php esc_html_e( 'If you have any questions, need a hand with a technical issue, or just want to say hi, we\'ve got you covered. Get in touch with us and we\'ll be happy to assist you!', 'meta-box' ); ?><p>
						<a class="mb-dashboard__external" target="_blank" href="https://support.metabox.io">
							<?php esc_html_e( 'Go to the support forum', 'meta-box' ); ?>
						<svg><use xlink:href="#external-link"></use></svg>
						</a>
				</div>
			</div>
		<?php endif; ?>

		<div class="mb-dashboard__widget mb-dashboard__plugins">
			<div class="mb-dashboard__widget-title"><?php esc_html_e( 'Recommended plugins', 'meta-box' ) ?></div>
			<div class="mb-dashboard__widget-body">
				<?php
				// phpcs:disable
				$plugins = [
					[
						'title'       => 'Slim SEO',
						'slug'        => 'slim-seo',
						'description' => __( 'Fast & Automated WordPress SEO Plugin', 'meta-box' ),
						'url'         => 'https://wpslimseo.com',
					],
					[
						'title'       => 'Falcon',
						'slug'        => 'falcon',
						'description' => __( 'WordPress Optimizations & Tweaks', 'meta-box' ),
						'url'         => 'https://wpfalcon.pro',
					],
				];
				?>
				<?php foreach ( $plugins as $plugin ) : ?>
					<div class="mb-dashboard__plugin">
						<img src="<?php echo esc_attr( "{$this->assets_url}/img/{$plugin['slug']}.svg" ); ?>" alt="<?php echo esc_attr( $plugin['title'] ); ?>" />
						<div class="mb-dashboard__plugin__text">
							<a class="mb-dashboard__plugin__title" href="<?php echo esc_attr( $plugin['url'] ); ?>" target="_blank"><?php echo esc_html( $plugin['title'] ); ?></a>
							<div class="mb-dashboard__plugin__description"><?php echo esc_html( $plugin['description'] ); ?></div>
						</div>
						<?php $status = $this->get_plugin_status( $plugin['slug'] ); ?>
						<span class="mb-dashboard__plugin__status" data-plugin="<?php echo esc_attr( $plugin['slug'] ); ?>" data-action="<?php echo esc_attr( $status['action'] ); ?>" data-processing="<?php echo esc_attr( $status['processing'] ); ?>" data-done="<?php echo esc_attr( $status['done'] ); ?>">
							<?php echo esc_html( $status['text'] ); ?>
						</span>
					</div>
				<?php endforeach; ?>
				<?php // phpcs:enable ?>
			</div>
		</div>

		<div class="mb-dashboard__widget">
			<div class="mb-dashboard__widget-title"><?php esc_html_e( 'Join the community', 'meta-box' ) ?></div>
			<div class="mb-dashboard__widget-body">
				<p><?php esc_html_e( 'Share opinions, ask questions and help each other on our Meta Box community!', 'meta-box' ); ?></p>
				<a class="mb-dashboard__external" href="https://www.facebook.com/groups/metaboxusers" target="_blank">
					<?php esc_html_e( 'Join our Facebook Group', 'meta-box' ); ?>
					<svg><use xlink:href="#external-link"></use></svg>
				</a>
			</div>
		</div>

		<div class="mb-dashboard__widget">
			<div class="mb-dashboard__widget-title"><?php esc_html_e( 'Leave us a review', 'meta-box' ) ?></div>
			<div class="mb-dashboard__widget-body">
				<p><?php esc_html_e( 'Are you are enjoying Meta Box? We would love to hear your feedback.', 'meta-box' ) ?></p>
				<a class="mb-dashboard__external" href="https://wordpress.org/support/plugin/meta-box/reviews/?filter=5" target="_blank">
					<?php esc_html_e( 'Submit a review', 'meta-box' ) ?>
					<svg><use xlink:href="#external-link"></use></svg>
				</a>
			</div>
		</div>
	</aside>

</div>

<div
	class="mb-dashboard__news"
	data-empty="<?php esc_html_e( 'No items available', 'meta-box' ); ?>"
	data-fetching="<?php esc_html_e( 'Getting news...', 'meta-box' ); ?>"
>
	<div class="mb-dashboard__news__header">
		<div class="mb-dashboard__news__heading"><?php esc_html_e( 'What\'s new?', 'meta-box' ); ?></div>
		<button class="mb-dashboard__news__close">
			<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
				<path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
			</svg>
		</button>
	</div>

	<div class="mb-dashboard__news__list"></div>
</div>

<svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
	<symbol id="check-circle-solid" viewBox="0 0 24 24">
		<path d="M12 2C6.486 2 2 6.486 2 12s4.486 10 10 10 10-4.486 10-10S17.514 2 12 2zm-1.999 14.413-3.713-3.705L7.7 11.292l2.299 2.295 5.294-5.294 1.414 1.414-6.706 6.706z"></path>
	</symbol>
	<symbol id="check-circle" viewBox="0 0 24 24" fill="var(--mb-color-accent)">
		<path d="M12 2C6.486 2 2 6.486 2 12s4.486 10 10 10 10-4.486 10-10S17.514 2 12 2zm0 18c-4.411 0-8-3.589-8-8s3.589-8 8-8 8 3.589 8 8-3.589 8-8 8z"></path>
		<path d="M9.999 13.587 7.7 11.292l-1.412 1.416 3.713 3.705 6.706-6.706-1.414-1.414z"></path>
	</symbol>
	<symbol id="x-circle" viewBox="0 0 24 24" fill="#dc2626">
		<path d="M9.172 16.242 12 13.414l2.828 2.828 1.414-1.414L13.414 12l2.828-2.828-1.414-1.414L12 10.586 9.172 7.758 7.758 9.172 10.586 12l-2.828 2.828z"></path>
		<path d="M12 22c5.514 0 10-4.486 10-10S17.514 2 12 2 2 6.486 2 12s4.486 10 10 10zm0-18c4.411 0 8 3.589 8 8s-3.589 8-8 8-8-3.589-8-8 3.589-8 8-8z"></path>
	</symbol>
	<symbol id="external-link" viewBox="0 0 24 24">
		<path d="m13 3 3.293 3.293-7 7 1.414 1.414 7-7L21 11V3z"></path>
		<path d="M19 19H5V5h7l-2-2H5c-1.103 0-2 .897-2 2v14c0 1.103.897 2 2 2h14c1.103 0 2-.897 2-2v-5l-2-2v7z"></path>
	</symbol>
</svg>
